import Vue from 'vue'
import VueI18n from 'vue-i18n'
import ElementLocale from 'element-ui/lib/locale'
import plLocale from 'element-ui/lib/locale/lang/pl'

import {pl} from '../locales/pl.js'

Vue.use(VueI18n)

const i18n = new VueI18n({
  locale: 'pl',
  messages: {
    pl: {
      ...pl,
      ...plLocale
    },
  }
})

ElementLocale.i18n((key, value) => i18n.t(key, value))

export default i18n
