<?php

namespace App\Services\Users;

use App\Core\Transactions\TransactionInterface;
use App\Entity\Units\UnitsInterface;
use App\Entity\Users\User;
use App\Models\Users\UserUnitAssignModel;

class UpdateUnitAssign
{
    public function __construct(
        private TransactionInterface $transaction,
        private UnitsInterface $units,
    ) {}

    public function update(User $user, UserUnitAssignModel $units): void
    {
        $sentUnits = $units->getUnitsIDs();
        $userUnits = $user->getAssignedUnitsIDs();

        $toAdd = array_diff($sentUnits, $userUnits);
        $toRemove = array_diff($userUnits, $sentUnits);

        $this->transaction->begin();

        $unitsToAdd = $this->units->findAllByIDs($toAdd);
        foreach ($unitsToAdd as $unit) {
            $user->addAssignedUnit($unit);
        }

        $unitsToRemove = $this->units->findAllByIDs($toRemove);
        foreach ($unitsToRemove as $unit) {
            $user->removeAssignedUnit($unit);
        }

        $this->transaction->end();
    }
}