<?php

namespace App\Services\Users;

use App\Core\Exception\ApiException;
use App\Core\Transactions\TransactionInterface;
use App\Entity\Users\User;
use Symfony\Contracts\Translation\TranslatorInterface;

class ActivateAccount
{
    public function __construct(
        private TranslatorInterface $translator,
        private TransactionInterface $transaction
    ) {}

    /** @throws ApiException */
    public function activate(User $user): void
    {
        if ($user->getIsActive()) {
            throw new ApiException($this->translator->trans('account.is_activated'));
        }

        $this->transaction->begin();

        $user->activate();

        $this->transaction->end();
    }
}