<?php

namespace App\Services\Units;

use App\Core\Transactions\TransactionInterface;
use App\Entity\Units\Unit;

class PublishUnit
{
    public function __construct(
        private TransactionInterface $transaction
    ) {}

    public function publish(Unit $unit): void
    {
        $this->transaction->begin();
        $unit->publish();
        $this->transaction->end();
    }
}