<?php

namespace App\Services\Units;

use App\Core\File\FileUploader\FileUploaderInterface;
use App\Core\Transactions\TransactionInterface;
use App\Entity\Units\Factory\UnitFactory;
use App\Entity\Units\UnitID;
use App\Entity\Units\UnitsInterface;
use App\Models\Units\UnitModel;

class CreateUnit
{
    public function __construct(
        private TransactionInterface $transaction,
        private UnitFactory $unitFactory,
        private FileUploaderInterface $fileUploader,
        private UnitsInterface $units
    ) {}

    public function create(UnitModel $unitModel): UnitID
    {
        $this->transaction->begin();

        $unit = $this->unitFactory->create($unitModel);

        $this->fileUploader->upload($unitModel->getPhoto());
        $this->fileUploader->upload($unitModel->getBanner());

        $this->units->add($unit);

        $this->transaction->end();

        return $unit->getUuid();
    }
}