<?php

namespace App\Services\Posts;

use App\Core\Transactions\TransactionInterface;
use App\Entity\Posts\Post;

class DeletePost
{
    public function __construct(
        private TransactionInterface $transaction
    ) {}

    public function delete(Post $post): void
    {
        $this->transaction->begin();

        $post->deactivate();

        $this->transaction->end();
    }
}