<?php

namespace App\Services\Orders;


use App\Core\Transactions\TransactionInterface;
use App\Entity\Orders\Classes\OrderManagerInterface;
use App\Entity\Orders\OrdersInterface;
use App\Entity\Subscriptions\Subscription;
use App\Models\Orders\RenewSubscriptionModel;
use App\PaymentSystem\PaymentTransaction;
use App\PaymentSystem\Przelewy24Interface;

class SubscriptionRenew
{
    public function __construct(
        private TransactionInterface $transaction,
        private Przelewy24Interface $p24,
        private OrderManagerInterface $orderManager,
        private OrdersInterface $orders,
    )
    {
    }

    public function renewOneTimeSubscription(Subscription $subscription, RenewSubscriptionModel $renewSubscriptionModel): string
    {
        $monthlyCost = $subscription->getRenewalMonthlyCostByStatus($renewSubscriptionModel->isUnitMonthlyCost());
        $order = $this->orderManager->createRenewSubscriptionOrder($subscription, $renewSubscriptionModel->getMonths(), $monthlyCost);

        $paymentTransaction = PaymentTransaction::fromOrder($order);

        $paymentTransaction = $this->p24->transaction(
            $paymentTransaction
        );

        $order->setToken($paymentTransaction->token());


        $this->transaction->begin();

        $this->orders->add($order);

        $this->transaction->end();

        return $paymentTransaction->redirectUrl();
    }
}