<?php

namespace App\Services\LoginUserHistories;

use App\Core\Transactions\TransactionInterface;
use App\Entity\LoginUserHistories\Factory\LoginHistoryFactory;
use App\Entity\LoginUserHistories\LoginUserHistoriesInterface;
use App\Entity\Users\User;

class CreateLoginHistory
{
    public function __construct(
        private LoginHistoryFactory $loginHistoryFactory,
        private TransactionInterface $transaction,
        private LoginUserHistoriesInterface $loginUserHistories,
    ) {}

    public function create(User $user, string $clientIp): void
    {
        $loginHistory = $this->loginHistoryFactory->buildHistory($user, $clientIp);

        $this->transaction->begin();

        $this->loginUserHistories->add($loginHistory);
        $user->clearToken();

        $this->transaction->end();
    }
}