<?php

namespace App\Services\BalanceOperations;

use App\Core\Transactions\TransactionInterface;
use App\Entity\BalanceOperations\BalanceOperation;
use App\Entity\BalanceOperations\Classes\BalanceOperationsManagerInterface;
use App\Entity\Users\User;
use App\Models\BalanceOperations\CreateBalanceOperationModel;
use Psr\Log\LoggerInterface;

class CreateBalanceOperation
{
    public function __construct(
        private BalanceOperationsManagerInterface $balanceOperationsManager,
        private TransactionInterface $transaction,
        private LoggerInterface $paymentLogger
    )
    {
    }

    public function create(User $admin, User $volunteer, CreateBalanceOperationModel $balanceOperationModel): BalanceOperation
    {
        $this->transaction->begin();

        $balanceOperation = $this->balanceOperationsManager->createBalanceOperationByAdmin($volunteer, $balanceOperationModel->getTitle(), $balanceOperationModel->getAmount());

        $this->transaction->end();

        $this->paymentLogger->info('Balance operation: ' . $balanceOperation->getUuid() . ' created by user: ' . $admin->getUuid());

        return $balanceOperation;
    }
}