<?php

namespace App\ReportSystem;

use App\ReportSystem\Core\ExcelConfig;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Color;

class SubscriptionReportConfig extends ExcelConfig
{
    protected array $styles = [
        'borders' => [
            'allBorders' => [
                'borderStyle' => Border::BORDER_THIN,
                'color' => [Color::COLOR_BLACK],
            ],
        ],
    ];

    protected array $columns = [
        'Id subskrypcji',
        'Id zbiórki',
        'Nazwa zbiórki',
        'Typ zbiórki',
        'Id użytkownika',
        'Imię',
        'Nazwisko',
        'Email',
        'Kod wolontariusza',
        'Typ płatności',
        'Data założenia',
        'Data ważności',
        'Data zakończenia',
        'Tryb wygaśnięcia',
        'Kwota miesięczna'
    ];

    protected string $filename = 'SubscriptionReport';


    public function __construct(array $data, string $publicDir, string $filename = null, array $extraColumns = [])
    {
        $this->data = $data;
        $this->columns = array_merge($this->columns, $extraColumns);
        $this->filename = $filename ?: $this->filename;
        $this->publicDir = $publicDir;
    }


}