<?php

namespace App\PaymentSystem;

use App\PaymentSystem\Api\Request\ApiRequest;
use App\PaymentSystem\Api\Request\ParametersApiRequest;

class TransactionCardCharge implements ParametersApiRequest
{
    public function __construct(private string $token)
    {
    }

    /**
     * @return string
     */
    public function getToken(): string
    {
        return $this->token;
    }

    public function parameters(): array
    {
        return [
            'token' => $this->getToken()
        ];
    }
}