<?php

namespace App\PaymentSystem\Api\Response;

use App\PaymentSystem\Exceptions\TransactionNumberNotFoundException;
use App\PaymentSystem\Helper\P24Finder;

class InfoTransactionResponse extends ApiResponse
{
    protected $statement;
    protected $orderId;
    protected $sessionId;
    protected $status;
    protected $amount;
    protected $currency;
    protected $date;
    protected $dateOfTransaction;
    protected $clientEmail;
    protected $accountMD5;
    protected $paymentMethod;
    protected $description;
    protected $clientName;
    protected $clientAddress;
    protected $clientCity;
    protected $clientPostcode;
    protected $batchId;
    protected $fee;

    /**
     * @return mixed
     */
    public function getStatement()
    {
        return $this->statement;
    }

    /**
     * @return mixed
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @return mixed
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }

    /**
     * @return mixed
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @return mixed
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * @return mixed
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @return mixed
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @return mixed
     */
    public function getDateOfTransaction()
    {
        return $this->dateOfTransaction;
    }

    /**
     * @return mixed
     */
    public function getClientEmail()
    {
        return $this->clientEmail;
    }

    /**
     * @return mixed
     */
    public function getAccountMD5()
    {
        return $this->accountMD5;
    }

    /**
     * @return mixed
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }

    /**
     * @return mixed
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @return mixed
     */
    public function getClientName()
    {
        return $this->clientName;
    }

    /**
     * @return mixed
     */
    public function getClientAddress()
    {
        return $this->clientAddress;
    }

    /**
     * @return mixed
     */
    public function getClientCity()
    {
        return $this->clientCity;
    }

    /**
     * @return mixed
     */
    public function getClientPostcode()
    {
        return $this->clientPostcode;
    }

    /**
     * @return mixed
     */
    public function getBatchId()
    {
        return $this->batchId;
    }

    /**
     * @return mixed
     */
    public function getFee()
    {
        return $this->fee;
    }


    /**
     * @throws TransactionNumberNotFoundException
     */
    public function getTransactionNumber(): string
    {
        return P24Finder::findTransactionNumberByStatement($this->getStatement());
    }
}