<?php

namespace App\Models\Users;

use App\Core\ParamConverter\JsonModelConverter;
use App\Entity\Roles\RoleID;
use Symfony\Component\Validator\Constraints as Assert;

class UserRoleModel implements JsonModelConverter
{
    /** @var string $roleId */
    #[Assert\NotBlank]
    #[Assert\Uuid]
    private string $roleId;

    /**
     * @return RoleID
     */
    public function getRoleId(): RoleID
    {
        return RoleID::fromString($this->roleId);
    }

    /**
     * @param string $roleId
     */
    public function setRoleId(string $roleId): void
    {
        $this->roleId = $roleId;
    }
}