<?php

namespace App\Models\Units;

use App\Core\ParamConverter\JsonModelConverter;
use Symfony\Component\Validator\Constraints as Assert;

class UpdateCardInfoModel implements JsonModelConverter
{
    #[Assert\NotBlank]
    #[Assert\Type(type: 'string')]
    private string $content;

    /**
     * @return string
     */
    public function getContent(): string
    {
        return $this->content;
    }

    /**
     * @param string $content
     */
    public function setContent(string $content): void
    {
        $this->content = $content;
    }
}