<?php

namespace App\Models\Sliders;

use App\Core\File\FileToUpload\ImageToUpload;
use App\Core\ParamConverter\FormDataModelConverter;
use Symfony\Component\Validator\Constraints as Assert;

class SliderPhotosModel implements FormDataModelConverter
{
    #[Assert\Valid]
    /** @var ImageToUpload[] $photos */
    private array $photos = [];

    /**
     * @return ImageToUpload[]
     */
    public function getPhotos(): array
    {
        return $this->photos;
    }

    /**
     * @param array|string $photos
     */
    public function setPhotos(array|string $photos): void
    {
        foreach ((array) $photos as $photo) {
            if (!empty($photo)) {
                $this->photos[] = new ImageToUpload($photo);
            }
        }
    }
}