<?php

namespace App\Models\Sliders;

use App\Core\Exception\ApiException;
use App\Core\ParamConverter\JsonModelConverter;
use App\Entity\SliderImages\SliderImage;
use App\Entity\SliderImages\SliderImageID;
use App\Models\SliderImages\SliderImageModel;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Serializer\Annotation\Ignore;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Validator\Validator\ValidatorInterface;
use Nelmio\ApiDocBundle\Annotation\Model;
use OpenApi\Annotations as OA;

class SliderModel implements JsonModelConverter
{
    #[Assert\Positive]
    #[Assert\Type(type: 'integer')]
    private int $durationTime;

    #[Assert\Valid]
    #[Assert\Type(type:'array')]
    /**
     * @OA\Property(ref=@Model(type=SliderImageModel::class))
     */
    private array $photos = [];


    /**
     * @return int
     */
    public function getDurationTime(): int
    {
        return $this->durationTime;
    }

    /**
     * @param int $durationTime
     */
    public function setDurationTime(int $durationTime): void
    {
        $this->durationTime = $durationTime;
    }

    /**
     * @return array
     */
    public function getPhotos(): array
    {
        return $this->photos;
    }

    /**
     * @return SliderImageID[]
     */
    #[Ignore]
    public function getPhotosIDs(): array
    {
        return (new ArrayCollection($this->photos))
            ->map(fn($sliderImageId) => SliderImageID::fromString($sliderImageId->getPhotoId()))
            ->toArray();
    }

    /**
     * @param array
     */
    public function setPhotos(array $photos): void
    {
        try {
            $this->photos = array_map(fn($result) => SliderImageModel::FromArray($result), $photos);
        }
        catch (\Throwable $e)
        {
             throw new ApiException('Validation error');
        }
    }
}