<?php

namespace App\Models\Purposes;

use App\Core\ParamConverter\JsonModelConverter;
use App\Core\Utils\Money;
use Symfony\Component\Validator\Constraints as Assert;

class UpdatePurposeModel implements JsonModelConverter
{
    #[Assert\NotBlank]
    #[Assert\Type(type: 'string')]
    #[Assert\Length(max: 100)]
    private string $title;

    #[Assert\NotBlank]
    #[Assert\Type(type: 'float')]
    #[Assert\Range(min: 0)]
    private float $money;

    /** @var string $startedAt */
    #[Assert\NotBlank]
    #[Assert\Type(type: 'string')]
    #[Assert\Date]
    private string $startedAt;

    #[Assert\NotBlank]
    #[Assert\Type(type: 'string')]
    private string $content;

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @param string $title
     */
    public function setTitle(string $title): void
    {
        $this->title = $title;
    }

    /**
     * @return int
     */
    public function getMoney(): int
    {
        return Money::toMinor($this->money);
    }

    /**
     * @param float $money
     */
    public function setMoney(float $money): void
    {
        $this->money = $money;
    }

    /**
     * @return \DateTimeImmutable
     * @throws \Exception
     */
    public function getStartedAt(): \DateTimeImmutable
    {
        return new \DateTimeImmutable($this->startedAt);
    }

    /**
     * @param string $startedAt
     */
    public function setStartedAt(string $startedAt): void
    {
        $this->startedAt = $startedAt;
    }

    /**
     * @return string
     */
    public function getContent(): string
    {
        return $this->content;
    }

    /**
     * @param string $content
     */
    public function setContent(string $content): void
    {
        $this->content = $content;
    }
}