<?php

namespace App\Models\BankStatements;

use App\Core\File\FileToUpload\StatementToUpload;
use App\Core\ParamConverter\FormDataModelConverter;
use Symfony\Component\Validator\Constraints as Assert;

class BankStatementModel implements FormDataModelConverter
{
    #[Assert\Valid]
    /** @var StatementToUpload[] $statements */
    private array $statements = [];

    /**
     * @return StatementToUpload[]
     */
    public function getStatements(): array
    {
        return $this->statements;
    }

    /**
     * @param array|string $photos
     */
    public function setStatements(array|string $statements): void
    {
        foreach ((array) $statements as $statement) {
            if (!empty($statement)) {
                $this->statements[] = new StatementToUpload($statement);
            }
        }
    }
}