<?php

namespace App\Entity\Users\ReadModel;

use App\Core\Utils\FromArray;
use App\Core\Utils\Money;
use App\Entity\Users\UserID;

class VolunteerDTO
{
    use FromArray;

    public function __construct(
        private string $volunteerId,
        private string $name,
        private string $surname,
        private string $email,
        private string $referenceCode,
        public int $totalOperationsCount = 0,
        public int $adminOperationsCount = 0,
        public int $paymentOperationsCount = 0,
        public int $totalAmountCount = 0
    )
    {
        $this->volunteerId = (string)UserID::fromString($this->volunteerId);
    }

    /**
     * @return string
     */
    public function getVolunteerID(): string
    {
        return $this->volunteerId;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getSurname(): string
    {
        return $this->surname;
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * @return string
     */
    public function getReferenceCode(): string
    {
        return $this->referenceCode;
    }

    /**
     * @return float
     */
    public function getTotalOperationsCount(): float
    {
        return Money::toRational($this->totalOperationsCount);
    }

    /**
     * @return float
     */
    public function getAdminOperationsCount(): float
    {
        return Money::toRational($this->adminOperationsCount);
    }

    /**
     * @return float
     */
    public function getPaymentOperationsCount(): float
    {
        return Money::toRational($this->paymentOperationsCount);
    }

    /**
     * @return float
     */
    public function getTotalAmountCount(): float
    {
        return Money::toRational($this->totalAmountCount);
    }


}