<?php

namespace App\Entity\Users\ReadModel;

use App\Core\Utils\FromArray;
use App\Core\Utils\Money;

class VolunteerBalanceDTO
{
    use FromArray;


    public function __construct(
        public int $totalOperationsCount = 0,
        public int $adminOperationsCount = 0,
        public int $paymentOperationsCount = 0,
        public int $totalAmountCount = 0,
    )
    {
    }

    /**
     * @return float
     */
    public function getTotalOperationsCount(): float
    {
        return Money::toRational($this->totalOperationsCount);
    }

    /**
     * @return float
     */
    public function getAdminOperationsCount(): float
    {
        return Money::toRational($this->adminOperationsCount);
    }

    /**
     * @return float
     */
    public function getPaymentOperationsCount(): float
    {
        return Money::toRational($this->paymentOperationsCount);
    }

    /**
     * @return float
     */
    public function getTotalAmountCount(): float
    {
        return Money::toRational($this->totalAmountCount);
    }




}