<?php

namespace App\Entity\UserAgreementsHistory;

use App\Entity\Agreement\Agreement;
use App\Entity\Users\User;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\ORM\Mapping\Entity;
use Symfony\Component\Uid\Uuid;

/**
 * @Entity()
 */
class UserAgreementHistory
{
    /**
     * @ORM\Id
     * @ORM\Column(type="uuid")
     */
    private UserAgreementHistoryID|Uuid $uuid;

    /**
     * @ORM\ManyToOne(targetEntity=Agreement::class)
     * @ORM\JoinColumn(name="agreement_id", referencedColumnName="uuid", nullable=false)
     */
    private Agreement $agreement;

    /**
     * @ORM\ManyToOne(targetEntity=User::class)
     * @ORM\JoinColumn(name="user_id", referencedColumnName="uuid", nullable=false)
     */
    private User $user;

    /**
     * @ORM\Column(type="boolean")
     */
    private bool $prevStatus;

    /**
     * @ORM\Column(type="string", length=30)
     */
    private string $ip;

    /**
     * @ORM\Column(type="datetime_immutable")
     */
    private \DateTimeImmutable $createdAt;

    public function __construct(Agreement $agreement, User $user, bool $prevStatus, string $ip)
    {
        $this->uuid = UserAgreementHistoryID::generate();
        $this->agreement = $agreement;
        $this->user = $user;
        $this->prevStatus = $prevStatus;
        $this->ip = $ip;
        $this->createdAt = new \DateTimeImmutable();
    }

    /**
     * @return UserAgreementHistoryID
     */
    public function getUuid(): UserAgreementHistoryID
    {
        return UserAgreementHistoryID::fromString($this->uuid);
    }

    /**
     * @return Agreement
     */
    public function getAgreement(): Agreement
    {
        return $this->agreement;
    }

    /**
     * @return User
     */
    public function getUser(): User
    {
        return $this->user;
    }

    /**
     * @return bool
     */
    public function isPrevStatus(): bool
    {
        return $this->prevStatus;
    }

    /**
     * @return string
     */
    public function getIp(): string
    {
        return $this->ip;
    }

    /**
     * @return \DateTimeImmutable
     */
    public function getCreatedAt(): \DateTimeImmutable
    {
        return $this->createdAt;
    }
}