<?php

namespace App\Entity\Units\ReadModel;

use App\Core\Utils\FromArray;
use App\Entity\Units\UnitID;

class UnitChildrenDTO
{
    use FromArray;

    private function __construct(
        private string $unitId,
        private string $unitTitle,
        private ?string $parentUnitId = null
    ) {
        $this->unitId = UnitID::fromString($this->unitId);
    }

    /**
     * @return string
     */
    public function getUnitId(): string
    {
        return $this->unitId;
    }

    /**
     * @return string
     */
    public function getUnitTitle(): string
    {
        return $this->unitTitle;
    }

    /**
     * @return bool
     */
    public function getIsSelected(): bool
    {
        return !empty($this->parentUnitId);
    }
}