<?php

namespace App\Entity\Subscriptions\ReadModel;

use App\Entity\Subscriptions\Helper\ReasonForClosure;

class ReasonForClosureTranslations
{
    private static array $reasonTranslations = [
        ReasonForClosure::CANCEL => 'Anulowanie',
        ReasonForClosure::RENEWAL => 'Nieprzedłużenie',
        ReasonForClosure::PAYMENTS => 'Niemożność pobrania',
        ReasonForClosure::ACCOUNT => 'Blokada konta',
        ReasonForClosure::LOCK_UNIT => 'Zamknięcie zbiórki',
        ReasonForClosure::UNPAID => 'Nieopłacona'
    ];
    public function __construct(private string $reason)
    {
    }

    public function __toString(): string
    {
        if (isset(self::$reasonTranslations[$this->reason])) {
            return self::$reasonTranslations[$this->reason];
        }
        return $this->getOriginalStatus();
    }

    public function getOriginalStatus(): string
    {
        return $this->reason;
    }
}