<?php

namespace App\Entity\Reports\ReadModel;

use App\Core\Utils\FromArray;
use App\Core\Utils\Money;

class FinanceReportDTO
{
    use FromArray;

    public function __construct(
        private string $type,
        private string $title,
        private ?int $moneyPurpose = 0,
        private ?int $collectedMoney = 0,
        private ?int $children = 0,
        private ?int $supportedChildren = 0,
        private ?int $supportedChildrenMoney = 0,
        private ?int $totalMoney = 0
    )
    {
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @return float|null
     */
    public function getMoneyPurpose(): ?float
    {
        return Money::toRational($this->moneyPurpose);
    }

    /**
     * @return float|null
     */
    public function getCollectedMoney(): ?float
    {
        return Money::toRational($this->collectedMoney);
    }

    /**
     * @return int|null
     */
    public function getChildren(): ?int
    {
        return $this->children;
    }

    /**
     * @return int|null
     */
    public function getSupportedChildren(): ?int
    {
        return $this->supportedChildren;
    }

    /**
     * @return float|null
     */
    public function getSupportedChildrenMoney(): ?float
    {
        return Money::toRational($this->supportedChildrenMoney);
    }

    /**
     * @return float|null
     */
    public function getTotalMoney(): ?float
    {
        return Money::toRational($this->totalMoney);
    }


}