<?php

namespace App\Entity\Reports\ReadModel;

use App\Core\Utils\FromArray;
use App\Core\Utils\Money;

class AnnualReportOrderDTO
{
    use FromArray;

    public function __construct(
        private string $unitTitle,
        private string $verifiedAt,
        private string $transactionNumber,
        private string $amount
    )
    {
    }

    /**
     * @return string
     */
    public function getUnitTitle(): string
    {
        return $this->unitTitle;
    }

    /**
     * @return string
     */
    public function getVerifiedAt(): string
    {
        return (new \DateTimeImmutable($this->verifiedAt))->format('d.m.Y');
    }

    /**
     * @return string
     */
    public function getTransactionNumber(): string
    {
        return $this->transactionNumber;
    }

    /**
     * @return string
     */
    public function getAmount(): string
    {
        return $this->amount;
    }

    public function getPrice(): float
    {
        return Money::toRational($this->amount);
    }

}