<?php

namespace App\Entity\Purposes\ReadModel;

use App\Core\Utils\Money;
use App\Entity\HearthAdoption\HearthAdoptionID;

class HeartAdoptionDetailsDTO
{
    public function __construct(
        private string $hearthAdoptionId,
        private int $children,
        private int $supportedChildren,
        private string $adoptionContent,
        private int $monthlyCost
    ) {
        $this->hearthAdoptionId = (string) HearthAdoptionID::fromString($hearthAdoptionId);
    }

    /**
     * @return string
     */
    public function getHearthAdoptionId(): string
    {
        return $this->hearthAdoptionId;
    }

    /**
     * @return int
     */
    public function getChildren(): int
    {
        return $this->children;
    }

    /**
     * @return int
     */
    public function getSupportedChildren(): int
    {
        return $this->supportedChildren;
    }

    /**
     * @return string
     */
    public function getAdoptionContent(): string
    {
        return $this->adoptionContent;
    }

    /**
     * @return float
     */
    public function getMonthlyCost(): float
    {
        return Money::toRational($this->monthlyCost);
    }
}