<?php

namespace App\Entity\Posts\ReadModel;

use App\Core\Paginator\ObjectValue\PaginationRequest;
use App\Entity\Posts\PostID;
use App\Entity\Units\UnitID;

interface PostsQueryInterface
{
    /**
     * @param UnitID $unitID
     * @param PaginationRequest $paginationRequest
     * @return PostDataDTO[]
     */
    public function findAllPostsByUnitId(UnitID $unitID, PaginationRequest $paginationRequest): array;

    /**
     * @param UnitID $unitID
     * @param PaginationRequest $paginationRequest
     * @return array
     */
    public function findPublishedPostsByUnitId(UnitID $unitID, PaginationRequest $paginationRequest): array;

    /**
     * @param PostID $postID
     * @return PostDataDTO|null
     */
    public function findOnePostById(PostID $postID): ?PostDataDTO;
}