<?php

namespace App\Entity\Posts\ReadModel;

use App\Core\Utils\FromArray;
use App\Entity\Posts\PostID;

class PostDataDTO
{
    use FromArray;

    private function __construct(
        private string $postId,
        private string $title,
        private string $description,
        private string $createdAt,
        private bool $isPublished,
        private ?string $content = null,
        private ?string $photo = null
    ) {
        $this->postId = (string) PostID::fromString($this->postId);
    }

    /**
     * @return string
     */
    public function getPostId(): string
    {
        return $this->postId;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @return string
     */
    public function getDescription(): string
    {
        return $this->description;
    }

    /**
     * @return string
     */
    public function getCreatedAt(): string
    {
        return $this->createdAt;
    }

    /**
     * @return bool
     */
    public function getIsPublished(): bool
    {
        return $this->isPublished;
    }

    /**
     * @return string|null
     */
    public function getContent(): ?string
    {
        return $this->content;
    }

    /**
     * @return string|null
     */
    public function getPhoto(): ?string
    {
        return $this->photo;
    }


}