<?php

namespace App\Entity\Orders\ReadModel;

use App\Core\Utils\FromArray;
use App\Core\Utils\Money;

class PaymentHistoryDTO
{
    use FromArray;

    private function __construct(
        private string $unitTitle,
        private string $purpose,
        private string $action,
        private int $amount,
        private string $date
    ) {}

    /**
     * @return string
     */
    public function getUnitTitle(): string
    {
        return $this->unitTitle;
    }

    /**
     * @return string
     */
    public function getPurpose(): string
    {
        return $this->purpose;
    }

    /**
     * @return string
     */
    public function getAction(): string
    {
        return $this->action;
    }

    /**
     * @return float
     */
    public function getAmount(): float
    {
        return Money::toRational($this->amount);
    }

    /**
     * @return string
     */
    public function getDate(): string
    {
        return $this->date;
    }
}