<?php

namespace App\Entity\Orders\ReadModel;

use App\Core\Paginator\ObjectValue\PaginationRequest;
use App\Entity\Orders\OrderID;
use App\Entity\Users\UserID;

interface OrdersQueryInterface
{
    /**
     * @param UserID $userID
     * @param PaginationRequest $paginationRequest
     * @return PaymentHistoryDTO[]
     */
    public function findAllPaymentByUserId(UserID $userID, PaginationRequest $paginationRequest): array;

    /**
     * @param UserID $userID
     * @param PaginationRequest $paginationRequest
     * @return PaymentSubscriptionDTO[]
     */
    public function findAllSubscriptionByUserId(UserID $userID, PaginationRequest $paginationRequest): array;

    /**
     * @param OrderID $orderID
     * @return OrderDTO|null
     */
    public function findOneByOrderID(OrderID $orderID): ?OrderDTO;
}