<?php

namespace App\Entity\LoginUserHistories;

use App\Entity\Users\User;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity()
 */
class LoginUserHistory
{
    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     */
    private LoginUserHistoryID $uuid;

    /**
     * @ORM\ManyToOne(targetEntity=User::class)
     * @ORM\JoinColumn(name="user_id", referencedColumnName="uuid", nullable=false)
     */
    private User $user;

    /**
     * @ORM\Column(type="string", length=30)
     */
    private string $ip;

    /**
     * @ORM\Column(type="datetime_immutable")
     */
    private \DateTimeImmutable $createdAt;

    public function __construct(
        User $user,
        string $ip,
        \DateTimeImmutable $createdAt
    )
    {
        $this->uuid = LoginUserHistoryID::generate();
        $this->user = $user;
        $this->ip = $ip;
        $this->createdAt = $createdAt;
    }

    /**
     * @return LoginUserHistoryID
     */
    public function getUuid(): LoginUserHistoryID
    {
        return $this->uuid;
    }

    public function getUser(): User
    {
        return $this->user;
    }

    public function getIp(): ?string
    {
        return $this->ip;
    }

    public function setIp(string $ip): self
    {
        $this->ip = $ip;

        return $this;
    }

    /**
     * @return \DateTimeImmutable
     */
    public function getCreatedAt(): \DateTimeImmutable
    {
        return $this->createdAt;
    }
}
