<?php

namespace App\Entity\Images\ReadModel;

use App\Core\Utils\FromArray;
use App\Entity\Images\ImageID;

class GalleryDTO
{
    use FromArray;

    private function __construct(
        private string $photoId,
        private string $photo,
        private ?string $title = null
    ) {
        $this->photoId = (string) ImageID::fromString($photoId);
    }

    /**
     * @return string
     */
    public function getPhotoId(): string
    {
        return $this->photoId;
    }

    /**
     * @return string
     */
    public function getPhoto(): string
    {
        return $this->photo;
    }

    /**
     * @return string|null
     */
    public function getTitle(): ?string
    {
        return $this->title;
    }
}