<?php

namespace App\Entity\HearthAdoption\ReadModel;

use App\Core\Utils\FromArray;
use App\Core\Utils\Money;

class HearthAdoptionDTO
{
    use FromArray;

    private function __construct(
        private int $children,
        private int $monthlyCost,
        private string $content
    ) {}

    /**
     * @return int
     */
    public function getChildren(): int
    {
        return $this->children;
    }

    /**
     * @return float
     */
    public function getMonthlyCost(): float
    {
        return Money::toRational($this->monthlyCost);
    }

    /**
     * @return string
     */
    public function getContent(): string
    {
        return $this->content;
    }
}