<?php

namespace App\Entity\Agreement\ReadModel;

use App\Core\Utils\FromArray;
use App\Entity\Agreement\AgreementID;

class AgreementDTO
{
    use FromArray;

    private function __construct(
        private string $agreementId,
        private string $agreementName,
        private ?string $userId = null
    ) {
        $this->agreementId = AgreementID::fromString($this->agreementId);
    }

    /**
     * @return string
     */
    public function getAgreementId(): string
    {
        return $this->agreementId;
    }

    /**
     * @return string
     */
    public function getAgreementName(): string
    {
        return $this->agreementName;
    }

    /**
     * @return bool
     */
    public function getIsAssigned(): bool
    {
        return !empty($this->userId);
    }
}