<?php

namespace App\DataFixtures;

use App\Entity\Agreement\Factory\AgreementFactory;
use App\Entity\Permissions\Permission;
use App\Entity\Roles\Role;
use App\Entity\Users\Factory\UserFactory;
use App\Entity\Users\User;
use App\Entity\Users\UserID;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Persistence\ObjectManager;

class UserAccountFixtures extends Fixture implements OrderedFixtureInterface
{
    public function load(ObjectManager $manager)
    {
        $adminRole = $manager->getRepository(Role::class)->findOneBy(['originalName' => Role::ADMIN]);

        $user = new User(
            UserID::generate(),
            'ExampleName',
            'ExampleSurname',
            'admin@salvatti.pl',
            $adminRole
        );
        $user->setPassword('zaq1@WSX');
        $user->activate();

        $manager->persist($user);
        $manager->flush();
    }

    public function getOrder(): int
    {
        return 4;
    }
}
