<?php


namespace App\Core\PdfGenerator;


class PDFFile
{
    /**
     * @var string
     */
    private $fileName;
    /**
     * @var array
     */
    private $twigParameters;
    /**
     * @var string
     */
    private $paperFormat;
    /**
     * @var string
     */
    private $orientation;
    /**
     * @var string
     */
    private $twigName;
    /**
     * @var string
     */
    private $filePath;

    public function __construct(
        string $fileName,
        string $filePath,
        string $twigName,
        array $twigParameters,
        string $paperFormat,
        string $orientation
    )
    {
        $this->fileName = $fileName;
        $this->filePath = $filePath;
        $this->twigName = $twigName;
        $this->twigParameters = $twigParameters;
        $this->paperFormat = $paperFormat;
        $this->orientation = $orientation;
    }

    public function getFileName(): string
    {
        return $this->fileName;
    }

    public function getTwigParameters(): array
    {
        return $this->twigParameters;
    }

    public function getPaperFormat(): string
    {
        return $this->paperFormat;
    }

    public function getOrientation(): string
    {
        return $this->orientation;
    }

    public function getTwigName(): string
    {
        return $this->twigName;
    }

    public function getFilePath(): string
    {
        return $this->filePath;
    }

}