<?php

namespace App\Core\Paginator;

use App\Core\Paginator\ObjectValue\PaginationRequest;
use Doctrine\DBAL\Query\QueryBuilder;

class Paginator implements PaginatorInterface
{
    public function addPagination(QueryBuilder $queryBuilder, PaginationRequest $paginationRequest, bool $isOffset = false): QueryBuilder
    {
        $queryBuilder = self::countOver($queryBuilder);
        if ($paginationRequest->isValid()) {
            if ($isOffset)
                $this->paginationQueryTypePaging($queryBuilder, $paginationRequest);
            else
                $this->paginationQueryTypeLoadMore($queryBuilder, $paginationRequest);
        }

        return $queryBuilder;
    }

    private function paginationQueryTypePaging(QueryBuilder $queryBuilder, PaginationRequest $paginationRequest): QueryBuilder
    {
        return $queryBuilder
            ->setFirstResult($paginationRequest->getPagingFirstResultParameter())
            ->setMaxResults($paginationRequest->getItemPerPage());

    }

    private function paginationQueryTypeLoadMore(QueryBuilder $queryBuilder, PaginationRequest $paginationRequest): QueryBuilder
    {
        return $queryBuilder
            ->setMaxResults($paginationRequest->getLoadMoreMaxResultParameter());

    }

    public static function countOver(QueryBuilder $queryBuilder): QueryBuilder
    {
        return $queryBuilder
            ->addSelect('(COUNT(*) OVER()) as totalRow');
    }
}