<?php

namespace App\Core\File\SliderImageManager;

use App\Core\File\FileRemover\FileRemoverInterface;
use App\Core\File\FileToUpload\FileToUploadInterface;
use App\Core\File\FileUploader\FileUploaderInterface;
use App\Entity\SliderImages\Factory\SliderImageFactory;
use App\Entity\SliderImages\SliderImage;
use App\Entity\SliderImages\SliderImagesInterface;

class SliderImageManager implements SliderImageManagerInterface
{
    public function __construct(
        private FileRemoverInterface $fileRemover,
        private FileUploaderInterface $fileUploader,
        private SliderImagesInterface $sliderImages,
        private SliderImageFactory $sliderImageFactory,
    ) {}

    public function prepare(?SliderImage $image = null, ?FileToUploadInterface $imageToUpload = null): ?SliderImage
    {
        if ($imageToUpload) {
            if ($image) {
                $this->fileRemover->remove($image->getImage());
                $this->sliderImages->remove($image);
            }

            $this->fileUploader->upload($imageToUpload);
            return $this->sliderImageFactory->create($imageToUpload);
        }

        return $image;
    }
}