<?php

namespace App\Controller\Units\Data;

use App\Core\Paginator\ObjectValue\PaginationRequest;
use App\Entity\Images\ReadModel\ImagesQueryInterface;
use App\Entity\Permissions\Permission;
use App\Entity\Units\UnitID;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use OpenApi\Annotations as OA;

/**
 * @OA\Tag(name="Units")
 */
#[Route(path: '/api/units', name: 'units_')]
class UnitGalleryDataController extends AbstractController
{
    public function __construct(
        private ImagesQueryInterface $imagesQuery
    ) {}

    /**
     * @OA\Get(summary="Gallery photos")
     * @OA\Parameter(name="page", in="query", description="page number")
     * @OA\Parameter(name="perPage", in="query", description="item per page")
     * @OA\Parameter(name="isOffset", in="query", description="pagination type")
     */
    #[IsGranted(Permission::PUBLIC_ACCESS)]
    #[Route(path: '/{unitId}/gallery', name: 'show_gallery', methods: ['GET'])]
    public function showGallery(string $unitId, Request $request): JsonResponse
    {
        return $this->json(
            $this->imagesQuery->findGalleryPhotosByUnitId(
                UnitID::fromString($unitId),
                PaginationRequest::build($request),
                (bool) $request->get('isOffset')
            )
        );
    }
}