<?php

namespace App\Controller\Reports;

use App\Core\ValidatorModel\ValidatorModelInterface;
use App\Entity\Permissions\Permission;
use App\Entity\Reports\ReadModel\ReportsQueryInterface;
use App\Models\Reports\RequestDatesModel;
use App\ReportSystem\ExcelGenerator;
use App\ReportSystem\OrderReportConfig;
use OpenApi\Annotations as OA;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

/** @OA\Tag(name="Reports") */
#[Route('/api/reports', name: 'reports_')]
class OrdersReportController extends AbstractController
{
    public function __construct(
        private ReportsQueryInterface $reportsQuery,
        private ValidatorModelInterface $validator,
        private ExcelGenerator $excelGenerator

    )
    {
    }
    /**
     * @OA\Get(summary="Get orders report data, filename sent in headers Content-Dosposition, attachment attr")
     */
    #[IsGranted(Permission::UNIT_ADMINISTRATION)]
    #[Route(path: '/orders', name: 'orders', methods: ['GET'])]
    public function ordersReport(Request $request): BinaryFileResponse
    {
        $dateStart = $request->query->get('dateStart');
        $dateEnd = $request->query->get('dateEnd');

        $requestDates = new RequestDatesModel($dateStart, $dateEnd);
        $this->validator->validate($requestDates);

        $data = $this->reportsQuery->getOrdersReportData($requestDates);
        $stream = $this->excelGenerator->generateReport(new OrderReportConfig($data, $this->getParameter('file.report_dir')));

        $response = new BinaryFileResponse($stream);
        $response->setContentDisposition('attachment',$stream->getBasename());
        $response->headers->set('X-suggested-filename', $stream->getBasename());

        return $response;
    }
}