<?php

namespace App\Controller\Posts;

use App\Entity\Permissions\Permission;
use App\Entity\Posts\Post;
use App\Entity\Posts\PostID;
use App\Entity\Posts\ReadModel\PostsQueryInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;
use OpenApi\Annotations as OA;

/**
 * @OA\Tag(name="Posts")
 */
#[Route(path: '/api/posts', name: 'posts_')]
class PostDataController extends AbstractController
{
    public function __construct(
        private PostsQueryInterface $postsQuery
    ) {}

    /**
     * @OA\Get(summary="Single post")
     */
    #[IsGranted(Permission::PUBLIC_ACCESS)]
    #[Route(path: '/{postId}', name: 'show', methods: ['GET'])]
    #[ParamConverter('post', options: ['mapping' => ['postId' => 'uuid']])]
    public function showPost(Post $post): JsonResponse
    {
        return $this->json(
            $this->postsQuery->findOnePostById($post->getUuid())
        );
    }
}