<?php

namespace App\Controller\HearthAdoption;

use App\Entity\HearthAdoption\HearthAdoptionID;
use App\Entity\HearthAdoption\ReadModel\HearthAdoptionQueryInterface;
use App\Entity\Permissions\Permission;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;
use OpenApi\Annotations as OA;

/**
 * @OA\Tag(name="Hearth adoption")
 */
#[Route(path: '/api/hearth-adoptions', name: 'hearth_adoptions_')]
class HearthAdoptionDataController extends AbstractController
{
    public function __construct(
        private HearthAdoptionQueryInterface $hearthAdoptionQuery
    ) {}

    /**
     * @OA\Get(summary="Show hearth adoption")
     */
    #[Security("is_granted('ROLE_UNIT_ADMINISTRATION') or is_granted('ROLE_UNIT_REDACTION')")]
    #[Route(path: '/{hearthAdoptionId}', name: 'show', methods: ['GET'])]
    public function show(string $hearthAdoptionId): JsonResponse
    {
        return $this->json(
            $this->hearthAdoptionQuery->findOneHearthAdoptionById(
                HearthAdoptionID::fromString($hearthAdoptionId)
            )
        );
    }
}