<?php

namespace App\Command;

use App\Entity\Subscriptions\SubscriptionsInterface;
use App\PaymentSystem\Exceptions\ApiResponseException;
use App\PaymentSystem\Exceptions\Przelewy24Exception;
use App\Services\Orders\SubscriptionCardCharge;
use Psr\Log\LoggerInterface;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class SubscriptionsDailyChargeCommand extends Command
{
    protected static $defaultName = 'subscription:charge';

    public function __construct(
        private LoggerInterface $paymentLogger,
        private SubscriptionsInterface $subscriptions,
        private SubscriptionCardCharge $subscriptionCardCharge
    )
    {
        parent::__construct();
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->paymentLogger->info('Script ' . self::$defaultName . ' start');

        foreach ($this->subscriptions->findAllToCharge() as $subscription) {
            $this->subscriptionCardCharge->createOrderForSubscriptionCardCharge($subscription);
        }

        $this->paymentLogger->info('Script ' . self::$defaultName . ' end');

        return 1;
    }
}