<?php

namespace App\Adapter\Units;

use App\Entity\Units\Unit;
use App\Entity\Units\UnitID;
use App\Entity\Units\UnitsInterface;
use Doctrine\ORM\EntityManagerInterface;

class Units implements UnitsInterface
{
    public function __construct(
        private EntityManagerInterface $entityManager
    )
    {
    }

    public function add(Unit $unit): void
    {
        $this->entityManager->persist($unit);
    }

    public function findOneByUnitID(UnitID $unitID): Unit
    {
        return $this->entityManager->getRepository(Unit::class)->findOneBy(['uuid' => $unitID]);
    }

    public function findAllByIDs(array $unitIDs): array
    {
        $qb = $this->entityManager->createQueryBuilder();

        return $qb
            ->select('u')
            ->from(Unit::class, 'u')
            ->where($qb->expr()->in('u.uuid', ':unitIDs'))
            ->setParameter('unitIDs', array_map(fn($unitID) => $unitID->toBinary(), $unitIDs))
            ->getQuery()
            ->execute();
    }
}