<?php

namespace App\Adapter\SliderImages\ReadModel;

use App\Entity\SliderImages\ReadModel\SliderImageDTO;
use App\Entity\SliderImages\ReadModel\SliderImagesQueryInterface;
use App\Entity\Sliders\ReadModel\SliderDTO;
use App\Entity\Sliders\ReadModel\SliderQueryInterface;
use App\Entity\Sliders\SliderID;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Driver\Exception;
use Doctrine\DBAL\Exception as DBALException;

class SliderImagesQuery implements SliderImagesQueryInterface
{
    public function __construct(
        private Connection $connection,
    ) {}

    public function findSliderImagesBySliderId(SliderID $sliderID): array
    {
        $qb = $this->connection->createQueryBuilder();

        $query = $qb
            ->select('sI.unit_id as unitId')
            ->addSelect('sI.uuid as photoId')
            ->addSelect('sI.order_number as orderNumber')
            ->addSelect('sI.image as photo')
            ->addSelect('sI.description')
            ->addSelect('sI.title')
            ->from('slider_image', 'sI')
            ->where('sI.slider_id = :sliderID')
            ->setParameter('sliderID', $sliderID,'uuid')
            ->orderBy('sI.order_number');

        $results = $query->execute()->fetchAllAssociative();

        return array_map(fn($data) => SliderImageDTO::fromArray($data), $results);
    }
}