<?php

namespace App\Adapter\Roles\ReadModel;

use App\Entity\Roles\ReadModel\RoleDTO;
use App\Entity\Roles\ReadModel\RolesQueryInterface;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Exception;
use \Doctrine\DBAL\Driver\Exception as DriverException;

class RolesQuery implements RolesQueryInterface
{
    public function __construct(
        private Connection $connection
    ) {}

    /**
     * @throws Exception
     * @throws DriverException
     * @throws \ReflectionException
     */
    public function findAllRoles(): array
    {
        $qb = $this->connection->createQueryBuilder();

        $results = $qb
            ->select('r.uuid as roleId')
            ->addSelect('r.name')
            ->from('role', 'r')
            ->execute()
            ->fetchAllAssociative();

        return array_map(fn($role) =>  RoleDTO::fromArray($role), $results);
    }
}