<?php

namespace App\Adapter\Reports\Email;

use App\Core\Notification\NotifierManagerInterface;
use App\Core\UrlGenerator\Reports\ReportUrlGeneratorInterface;
use App\Entity\Reports\ReadModel\QuarterReportRecipientDTO;
use App\Entity\Reports\ReadModel\ReportsQueryInterface;
use App\Entity\Reports\Report;
use Symfony\Component\Notifier\Recipient\EmailRecipientInterface;

class ReportNotifications implements ReportNotificationsInterface
{
    const QUARTER_REPORT_SUBJECT = 'Raport Darczyńcy';
    const QUARTER_REPORT_TEMPLATE = 'email/quarter_report.html.twig';

    public function __construct(
        private NotifierManagerInterface $notifier,
        private ReportUrlGeneratorInterface $reportUrlGenerator
    )
    {
    }

    public function sendQuarterReportEmail(Report $report, QuarterReportRecipientDTO $recipientDTO): void
    {

        $context = [
            'userName' => $recipientDTO->getUserName(),
            'description' => $report->getDescription(),
            'postLink' => $this->reportUrlGenerator->generatePostURL($report->getUnit()->getUuid(), $report->getPost()->getUuid())
        ];

        $this->notifier->sendMail(self::QUARTER_REPORT_SUBJECT, $context, self::QUARTER_REPORT_TEMPLATE, $recipientDTO);
    }
}