<?php

namespace App\Adapter\Posts;

use App\Entity\Posts\Post;
use App\Entity\Posts\PostID;
use App\Entity\Posts\PostsInterface;
use App\Entity\Units\UnitID;
use Doctrine\ORM\EntityManagerInterface;

class Posts implements PostsInterface
{
    public function __construct(
        private EntityManagerInterface $entityManager
    )
    {
    }

    public function add(Post $post): void
    {
        $this->entityManager->persist($post);
    }

    public function remove(Post $post): void
    {
        $this->entityManager->remove($post);
    }

    public function findOnePostById(PostID $postID): ?Post
    {
        return $this->entityManager
            ->getRepository(Post::class)
            ->findOneBy(['uuid' => $postID]);
    }

    public function findOneByPostIDAndUnitID(PostID $postID, UnitID $unitID): ?Post
    {
        return $this->entityManager
            ->getRepository(Post::class)
            ->findOneBy([
                'uuid' => $postID,
                'unit' => $unitID
            ]);
    }
}