<?php

namespace App\Adapter\BalanceOperations;

use App\Entity\BalanceOperations\BalanceOperation;
use App\Entity\BalanceOperations\BalanceOperationsInterface;
use App\Entity\Users\User;
use App\Entity\Users\UserID;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\NonUniqueResultException;
use Doctrine\ORM\NoResultException;

class BalanceOperations implements BalanceOperationsInterface
{
    public function __construct(
        private EntityManagerInterface $entityManager
    )
    {
    }

    public function add(BalanceOperation $balanceOperation): void
    {
        $this->entityManager->persist($balanceOperation);
    }

    /**
     * @throws NonUniqueResultException
     * @throws NoResultException
     */
    public function getBalanceByUserID(User $user, int $amount = 0): int
    {
        $qb = $this->entityManager->createQueryBuilder();

        $balance = (int)$qb
            ->select('SUM(b.amount) as totalCount')
            ->from(BalanceOperation::class, 'b')
            ->where('b.user = :userID')
            ->setParameter('userID', $user->getUuid(), 'uuid')
            ->getQuery()
            ->getSingleScalarResult();

        return $balance + $amount;
    }
}