export default {
    namespaced: true,
    state: {
      volunteerCode: null,
      donorEmail: null,
      declaredAmount: null,
    },
    mutations: {
      SET_VOLUNTEER_CODE(state, code) {
        state.volunteerCode = code
      },
      SET_DONOR_EMAIL(state, email) {
        state.donorEmail = email
      },
      SET_AMOUNT(state, amount) {
        state.declaredAmount = amount
      }

    },
    actions: {
        setVolunteerCode: ({commit}, payload) => {
            commit('SET_VOLUNTEER_CODE', payload)
        },
        setDonorEmail: ({commit}, payload) => {
            commit('SET_DONOR_EMAIL', payload)
        },
        setAmount: ({commit}, payload) => {
            commit('SET_AMOUNT', payload)
        }


    },
    getters: {
        volunteerCode:  state => state.volunteerCode,
        donorEmail:  state => state.donorEmail,
        declaredAmount:  state => state.declaredAmount,
    }
  }
  